package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;

import de.fzi.maintainabilitymodel.workplan.Activity;

/**
 * Command to set a worktime estimation to a given activity. It is realized as a command, because
 * this operation causes a change in the analysis model, which should be saved.
 * 
 * @author tknapp
 */
public class EditTimeEffortCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(EditTimeEffortCommand.class);

    /**
     * The activity for which the estimation has been done.
     */
    private Activity activity;

    /**
     * The estimation value as a double.
     */
    private Double value;

    public EditTimeEffortCommand(Activity activity, Double value) {
        this.activity = activity;
        this.value = value;
    }

    /**
     * Sets the double estimation value.
     */
    @Override
    public void execute() {
        activity.setWorkTimeEstimate(value);
    }

    /**
     * Not implemented.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub

    }

    /**
     * Assures that all parameters are unequal to <code>null</code>.
     */
    @Override
    public boolean canExecute() {
        if (this.activity != null && this.value != null)
            return true;
        return super.canExecute();
    }

}
