package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.impl.NotificationImpl;

import de.fzi.kamp.service.preparation.impl.PreparationManager;
import de.fzi.maintainabilitymodel.main.MainPackage;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;

/**
 * Command to edit an change request. It is realized as a command, because this operation causes a
 * change in the analysis model, which should be saved.
 * 
 * @author tknapp
 */
public class EditChangeRequestCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(EditChangeRequestCommand.class);

    /**
     * Preparation manager to get the dialog manager.
     */
    private PreparationManager preparationManager;

    /**
     * The change request which should be edited.
     */
    private ChangeRequest changeRequest;

    public EditChangeRequestCommand(PreparationManager preparationManager, ChangeRequest changeRequest) {
        this.preparationManager = preparationManager;
        this.changeRequest = changeRequest;
    }

    /**
     * Delegates the editing order via the preparation manager to the dialog manager.
     */
    @Override
    public void execute() {

        this.preparationManager.getAnalysisModel().eNotify(new NotificationImpl(0, null, null) {

            @Override
            public int getFeatureID(Class<?> expectedClass) {
                return MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__CHANGEREQUESTS;
            }

            @Override
            public boolean isTouch() {
                return true;
            }
        });

    }

    /**
     * Not implemented.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub

    }

    /**
     * Assures that all parameters are unequal to <code>null</code>.
     */
    @Override
    public boolean canExecute() {
        if (this.preparationManager != null && this.changeRequest != null)
            return true;
        else
            return false;
    }

}
