package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.impl.NotificationImpl;

import de.fzi.kamp.service.preparation.IPreparationManager;
import de.fzi.maintainabilitymodel.main.MainPackage;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;

/**
 * Command to edit an architecture alternative. It is realized as a command, because this operation
 * causes a change in the analysis model, which should be saved.
 * 
 * @author tknapp
 */
public class EditArchiAltCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(EditArchiAltCommand.class);

    /**
     * Preparation manager to get the dialog manager.
     */
    private IPreparationManager preparationManager;

    /**
     * The architecture alternative which should be edited.
     */
    private ArchitecturalAlternative architectureAlternative;

    public EditArchiAltCommand(IPreparationManager preparationManager, ArchitecturalAlternative architectureAlternative) {
        this.preparationManager = preparationManager;
        this.architectureAlternative = architectureAlternative;
    }

    /**
     * Delegates the editing order via the preparation manager to the dialog manager.
     */
    @Override
    public void execute() {

        this.preparationManager.getAnalysisModel().eNotify(new NotificationImpl(0, null, null) {

            @Override
            public int getFeatureID(Class<?> expectedClass) {
                return MainPackage.MAINTAINABILITY_ANALYSIS_MODEL__ARCHITECTUREALTERNATIVES;
            }

            @Override
            public boolean isTouch() {
                return true;
            }
        });
    }

    /**
     * Not implemented.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub

    }

    /**
     * Assures that all parameters are unequal to <code>null</code>.
     */
    @Override
    public boolean canExecute() {
        if (this.preparationManager != null && this.architectureAlternative != null) {
            return true;
        } else
            return false;
    }
}
