package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.workplanmanagement.NewWorkplanBuilder;
import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;

/**
 * Command to start the derivation process for the workplan. It is realized as a command, because
 * this operation causes a change in the analysis model, which should be saved.
 * 
 * @author tknapp
 */
public class DeriveWorkplanCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(DeriveWorkplanCommand.class);

    /**
     * The main editor.
     */
    private IMainEditor mainEditor;

    /**
     * The workplan which was created in the step before.
     */
    private Workplan workplan;

    /**
     * The container which wraps the new composite task which has been filled in the wizard.
     */
    private CompositeTaskDerivationContainer compositeTaskContainer;

    /**
     * The manager bundling all necessary functionality for the derivation process.
     * */
    private WorkplanDerivationManager workplanDerivationManager;

    public DeriveWorkplanCommand(Workplan workplan, IMainEditor mainEditor,
            CompositeTaskDerivationContainer compositeTaskContainer, WorkplanDerivationManager workplanDerivationManager) {
        this.workplan = workplan;
        this.mainEditor = mainEditor;
        this.compositeTaskContainer = compositeTaskContainer;
        this.workplanDerivationManager = workplanDerivationManager;
    }

    /**
     * Creates workplan and executes the delegation to the wizard manager.
     */
    @Override
    public void execute() {
        this.workplanDerivationManager.resetLastSelectedLists();

        new NewWorkplanBuilder(this.mainEditor).fillTasklistOfWorkplan(this.compositeTaskContainer, this.workplan);
//        new WorkPlanBuilder(this.mainEditor).fillTasklistOfWorkplan(this.compositeTaskContainer, this.workplan);
        this.mainEditor.showWorkplanChanges(this.workplan, false);
        this.mainEditor.getCentralPage().setAddCompositeActivityButtonVisible();
    }

    /**
     * Not implemented.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub

    }

    /**
     * Assures that all parameters are unequal to <code>null</code>.
     */
    @Override
    public boolean canExecute() {
        if (this.mainEditor != null && this.workplan != null && this.workplanDerivationManager != null
                && this.compositeTaskContainer != null) {
            return true;
        } else {
            return super.canExecute();
        }
    }
}
