package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

import de.fzi.kamp.service.general.IWizardManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.Workplan;

/**
 * Command to add an <code>EffortAnalysisInstance</code>. It is realized in a command, because this
 * operation causes a change in the analysis model, which should be saved.
 * 
 * @author tknapp
 * 
 */
public class DeriveFirstChangingDomainCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(DeriveFirstChangingDomainCommand.class);

    /**
     * The tree representing the workplan.
     */
    private Tree tree;

    /**
     * The editor used.
     */
    private IMainEditor editor;

    /**
     * The <code>WizardManager</code> to open the initial wizard to derive first changing domain.
     */
    private IWizardManager wizardManager;

    public DeriveFirstChangingDomainCommand(IMainEditor editor, Tree tree, IWizardManager wizardManager) {
        this.editor = editor;
        this.tree = tree;
        this.wizardManager = wizardManager;
    }

    /**
     * Extracts the <code>EffortAnalysisInstance</code> attached to the tree and delegates the order
     * to open the initial wizard.
     */
    @Override
    public void execute() {
        if (this.tree.getData() instanceof Workplan) {
            EffortAnalysisInstance instance = ((Workplan) tree.getData()).getEffortanalaysisinstance();
            this.wizardManager.showAddCompositeActivityWizard(instance, (Shell) null, editor, editor
                    .getArchitectureModelProvider());

        }
    }

    /**
     *Not implemented.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub

    }

    /**
     * Tests whether all input parameters are unequal to <code>null</code>.
     */
    @Override
    public boolean canExecute() {
        if (this.tree != null && this.editor != null && this.wizardManager != null)
            return true;
        else
            return false;
    }

}
