package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.jface.viewers.TableViewer;

import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement;

/**
 * Command to execute the order to remove an selected workorganisation element from one architecture
 * element. It is realized in a command, because this operation causes a change in the analysis
 * model, which should be saved.
 * 
 * @author tknapp
 * 
 */

public class DeleteSingleWOElementAssignmentCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(DeleteSingleWOElementAssignmentCommand.class);

    private WorkOrganisationElement workorganisationElement;
    private AbstractModelElement correspondingModelElement;
    private TableViewer tableViewer;

    public DeleteSingleWOElementAssignmentCommand(WorkOrganisationElement workorganisationElement,
            AbstractModelElement correspondingModelElement, TableViewer tableViewer) {
        super();
        this.workorganisationElement = workorganisationElement;
        this.correspondingModelElement = correspondingModelElement;
        this.tableViewer = tableViewer;
    }

    /**
     * Executes the removal of the selected workorganisation element from corresponding architecture
     * element.
     */
    @Override
    public void execute() {
        // at the moment the architecture model element is not stored in the corresponding
        // list in the workorganisation element, so the order is commented out
        // this.correspondingModelElement.getWorkorganisationelement().remove(workorganisationElement);
        this.workorganisationElement.getArchitecturemodelelement().remove(correspondingModelElement);

        this.tableViewer.setInput(this.correspondingModelElement.getWorkorganisationelement());
        this.tableViewer.refresh();

    }

    @Override
    public void redo() {
        // TODO Auto-generated method stub

    }

    /**
     * Tests whether all parameters are unequal to {@code null}.
     */
    @Override
    public boolean canExecute() {
        if (this.workorganisationElement != null && this.correspondingModelElement != null && this.tableViewer != null)
            return true;
        else
            return false;
    }
}
