package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.TreeItem;

import de.fzi.maintainabilitymodel.workplan.Activity;

/**
 * Command to remove an activity from workplan. It is realized as a command, because this operation
 * causes a change in the analysis model, which should be saved.
 * 
 * @author tknapp
 */
public class DeleteActivityFromWorkplanCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(DeleteActivityFromWorkplanCommand.class);

    /**
     * The <code>TreeItem</code> representing the activity in the workplan tree.
     */
    private TreeItem item;

    public DeleteActivityFromWorkplanCommand(TreeItem item) {
        this.item = item;
    }

    /**
     * Executes the remove operations (has to be improved).
     */
    @Override
    public void execute() {

        if (!(item.getItemCount() > 0) && item.getData() instanceof Activity) {
            Activity activity = (Activity) item.getData();
            activity.getSelectioncontainer().setSelected(false);
            activity.getSelectioncontainer().setActivity(null);
            EcoreUtil.remove(activity);
            item.dispose();
        }
    }

    /**
     * Not implemented.
     */
    @Override
    public void redo() {
    }

    /**
     * Assures that all parameters are unequal to <code>null</code>.
     */
    @Override
    public boolean canExecute() {
        if (item != null)
            return true;
        else
            return false;
    }
}
