package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;

/**
 * Command to remove all assigned workorganisation elements (Developers, Teams, Architects) of a
 * given component. It is realized in a command, because this operation causes a change in the
 * analysis model, which should be saved. * @author tknapp
 */
public class ClearWorkorganisationElementsCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(ClearWorkorganisationElementsCommand.class);

    /**
     * The <code>TableItem</code> representing the component in the table.
     */
    private TableItem item;

    /**
     * The <code>TableViewer</code> filling the central table of the dialog to assign
     * workorganisation elements.
     */
    private TableViewer assignedDevelopersViewer;

    public ClearWorkorganisationElementsCommand(TableItem item, TableViewer assignedDevelopersViewer) {
        super();
        this.item = item;
        this.assignedDevelopersViewer = assignedDevelopersViewer;
    }

    /**
     * Executes the clearance of all assigned workorganisation elements.
     */
    @Override
    public void execute() {
        if (item.getData() != null) {
            SAMMComponentProxy component = ((SAMMComponentProxy) item.getData());
            component.getWorkorganisationelement().clear();
            this.assignedDevelopersViewer.setInput(component.getWorkorganisationelement());
            this.assignedDevelopersViewer.refresh();
        }
    }

    /**
     * Not implemented.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub

    }

    /**
     * Assures that all parameters are unequal to <code>null</code>.
     */
    @Override
    public boolean canExecute() {
        if (this.item != null && this.assignedDevelopersViewer != null)
            return true;
        else
            return super.canExecute();
    }

}
