package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;

import de.fzi.kamp.service.preparation.impl.PreparationManager;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;

/**
 * Command to execute the check of the work complexity. The check is not implemented at the moment,
 * but the delegation to the preparation manager is implemented correctly in this command. It is
 * realized in a command,because this planned check causes a change in the analysis model, which
 * should be saved. * @author tknapp
 */
public class CheckComplexityAnnotationsCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(CheckComplexityAnnotationsCommand.class);

    /**
     * The <code>PreparationManager</code> to delegate the order to the <code>DialogManager</code>.
     */
    private PreparationManager preparationManager;

    /**
     * The <code>ArchitecturalAlternative</code> to be checked.
     */
    private ArchitecturalAlternative architectureAlternative;

    public CheckComplexityAnnotationsCommand(PreparationManager preparationManager,
            ArchitecturalAlternative architectureAlternative) {
        this.preparationManager = preparationManager;
        this.architectureAlternative = architectureAlternative;
    }

    /**
     * Delegates the order.
     */
    @Override
    public void execute() {
        this.preparationManager.getDialogManager().showCheckComplexityAnnotationsWizard();
    }

    /**
     * Not implemented.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub
    }

    /**
     * Assures that all parameters are unequal to <code>null</code>.
     */
    @Override
    public boolean canExecute() {
        if (this.preparationManager != null && this.architectureAlternative != null) {
            return true;
        } else
            return false;
    }
}
