package de.fzi.kamp.service.commands;

import java.util.Map;
import java.util.Map.Entry;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;

import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement;

/**
 * Command to apply the changes made to in the mapping of components to workorganisation elements
 * (Team, Developers, Architects). It is realized in a command, because of the changes in the
 * analysis model, which should be saved.
 * 
 * @author tknapp
 */
public class ApplyWorkorganisationElementsMappingCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(ApplyWorkorganisationElementsMappingCommand.class);

    /**
     *A map containing the temporary mappings of a component and a workorganisation element.
     */
    private Map<SAMMComponentProxy, WorkOrganisationElement> currentMappingMap;

    public ApplyWorkorganisationElementsMappingCommand(
            Map<SAMMComponentProxy, WorkOrganisationElement> currentMappingMap) {
        super();
        this.currentMappingMap = currentMappingMap;
    }

    /**
     * This methods writes all new mapping into the analysis model.
     */
    @Override
    public void execute() {
        for (Entry<SAMMComponentProxy, WorkOrganisationElement> entry : this.currentMappingMap.entrySet()) {
            ((SAMMComponentProxy) entry.getKey()).getWorkorganisationelement().add(
                    (WorkOrganisationElement) entry.getValue());
        }
    }

    /**
     * Not implemented.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub

    }

    /**
     * Assures that all parameters are unequal to <code>null</code>.
     */
    @Override
    public boolean canExecute() {
        if (this.currentMappingMap != null)
            return true;
        return super.canExecute();
    }
}
