package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.swt.widgets.Tree;

import de.fzi.kamp.service.general.IWizardManager;
import de.fzi.kamp.service.maineditor.IMainEditor;

/**
 * Command to add an <code>ChangeRequest</code>. It is realized in a command, because this operation
 * causes a change in the analysis model, which should be saved. * @author tknapp
 */
public class AddChangingDomainCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(AddChangingDomainCommand.class);

    /**
     * The <code>Tree</code> representing the workplan.
     */
    private Tree tree;

    /**
     * The main editor used.
     */
    private IMainEditor mainEditor;

    /**
     * The <code>WizardManager</code> for opening the wizard to select the properties of the new
     * changing domain.
     */
    private IWizardManager wizardManager;

    public AddChangingDomainCommand(Tree tree, IMainEditor mainEditor, IWizardManager wizardManager) {
        super();
        this.tree = tree;
        this.mainEditor = mainEditor;
        this.wizardManager = wizardManager;
    }

    /**
     * Delegates the order to open the wizard.
     */
    @Override
    public void execute() {
        logger.trace("execute");
        this.wizardManager.showFurtherWorkplanDerivationWizard(tree, mainEditor);
    }

    /**
     * Not implemented at the moment.
     */
    @Override
    public void redo() {
        // TODO Implement

    }

    /**
     * Tests whether all input parameters are unequal to <code>null</code>.
     */
    @Override
    public boolean canExecute() {
        if (this.tree != null && this.mainEditor != null && this.wizardManager != null)
            return true;
        else
            return false;
    }
}
