package de.fzi.kamp.service.commands;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;

import de.fzi.kamp.service.preparation.impl.PreparationManager;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;

public class AddChangeRequestCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(AddChangeRequestCommand.class);

    /**
     * The <code>PreparationManager</code> necessary for getting the <code>DialogManager</code> and
     * the analysis model.
     */
    private PreparationManager preparationManager;
    private ChangeRequest changeRequest;

    public AddChangeRequestCommand(PreparationManager preparationManager, ChangeRequest changeRequest) {
        this.preparationManager = preparationManager;
        this.changeRequest = changeRequest;
    }

    /**
     * Creates a change request, opens a dialog to ask the user about details of the change request
     * and then adds the change request to the analysis model.
     */
    @Override
    public void execute() {
        this.preparationManager.getAnalysisModel().getChangerequests().add(changeRequest);
    }

    /**
     * Not implemented at the moment.
     */
    @Override
    public void redo() {
        // TODO Auto-generated method stub

    }

    /**
     * Tests whether all parameters are unequal to <code>null</code>.
     */
    @Override
    public boolean canExecute() {
        if (this.preparationManager != null)
            return true;
        else
            return false;
    }
}
