package de.fzi.kamp.service.commands;


import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.AbstractCommand;

import de.fzi.kamp.service.analysisinstance.AlternativeAndChangeRequestTuple;
import de.fzi.kamp.service.analysisinstance.impl.AnalysisInstanceManager;
import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;

/**
 * Command to add an <code>EffortAnalysisInstance</code>. It is realized in a command, because this
 * operation causes a change in the analysis model, which should be saved. * @author tknapp
 * 
 */
public class AddAnalysisInstanceCommand extends AbstractCommand {
    private final static Logger logger = Logger.getLogger(AddAnalysisInstanceCommand.class);

    private AlternativeAndChangeRequestTuple result;
    private AnalysisManager analysisManager;
    private AnalysisInstanceManager instanceManager;

    public AddAnalysisInstanceCommand(AlternativeAndChangeRequestTuple result, AnalysisManager analysisManager) {

        this.result = result;
        this.analysisManager = analysisManager;
        /**
         * The <code>AnalysisInstanceManager</code> conducting the analysis instances.
         */
        this.instanceManager = (AnalysisInstanceManager) this.analysisManager.getAnalysisInstanceManager();
    }

    /**
     * Puts the <code>ArchitecturalAlternative</code> and the <code>ChangeRequest</code> as
     * <code>EffortAalysisInstance</code> into the given <code>MaintainabilityAnalysisModel</code>.
     */
    @Override
    public void execute() {
        if ((this.result.targetArchitectureAlternative != null) && (this.result.changeRequest != null)) {
            this.instanceManager.createAnalysisInstance(
	            this.result.sourceArchitectureAlternative,
	            this.result.changeRequest, 
	            this.analysisManager, 
	            this.result.targetArchitectureAlternative); 
        }
    }

    /**
     * Not implemented at the moment.
     */
    @Override
    public void redo() {
    }

    /**
     * Tests whether all input parameters are unequal to <code>null</code>.
     */
    @Override
    public boolean canExecute() {
        if (this.analysisManager != null)
            return true;
        else
            return super.canExecute();
    }

}
