package de.fzi.kamp.service.architecturemodel.impl.switches;

import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import de.fzi.maintainabilitymodel.architecturemodel.ArchitecturemodelFactory;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMCompositeComponentProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMDatatypeProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfacePortProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfaceProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMOperationDefinitionProxy;
import eu.qimpress.samm.datatypes.Type;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeComponent;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.util.StaticstructureSwitch;

public class SAMMProxyCreationSwitch extends StaticstructureSwitch<AbstractModelElement> {
	
	public SAMMProxyCreationSwitch() {		
	}
	
	@Override
	public AbstractModelElement caseCompositeComponent(CompositeComponent object) {
		SAMMCompositeComponentProxy proxy = ArchitecturemodelFactory.eINSTANCE.createSAMMCompositeComponentProxy();
		proxy.setCompositeComponent(object);
		return proxy;
	}
	
	@Override
	public AbstractModelElement caseComponentType(ComponentType componentType) {
		SAMMComponentProxy proxy = ArchitecturemodelFactory.eINSTANCE.createSAMMComponentProxy();
        proxy.setComponenttype(componentType);
		return proxy;
	}
	
	@Override
	public AbstractModelElement caseInterfacePort(InterfacePort interfacePort) {
		SAMMInterfacePortProxy proxy = ArchitecturemodelFactory.eINSTANCE.createSAMMInterfacePortProxy();
        proxy.setInterfaceport(interfacePort);
		return proxy;
	}
	
	@Override
	public AbstractModelElement caseInterface(Interface iface) {
		SAMMInterfaceProxy proxy = ArchitecturemodelFactory.eINSTANCE.createSAMMInterfaceProxy();
        proxy.setInterface(iface);
		return proxy;
	}
	
	@Override
	public AbstractModelElement caseOperation(Operation operation) {
		
		/*
		 * The operation implementation is handled differently, because it has to be exclusively differentiated 
		 * between SAMMOperationDefinitionProxy and SAMMOperationImplementationProxy. This differentiation
		 * cannot be done just based on the static structure element, because SAMMOperationImplementation
		 * is a 2:1 mapping ([InterfacePort, Operation] -> SAMMOperationImplementationProxy).
		 * Here just the operation definition proxy is created.
		 */
		
		SAMMOperationDefinitionProxy proxy = ArchitecturemodelFactory.eINSTANCE.createSAMMOperationDefinitionProxy();
		proxy.setOperation(operation);

		return proxy;
	}
	
	@Override
	public AbstractModelElement defaultCase(EObject object) {
		if(object instanceof Type){
			SAMMDatatypeProxy proxy = ArchitecturemodelFactory.eINSTANCE.createSAMMDatatypeProxy();
             proxy.setType((Type) object);
             return proxy;
		}else{
			return null;
		}
	}
}
