package de.fzi.kamp.service.architecturemodel.impl.switches;

import de.fzi.maintainabilitymodel.architecturemodel.AbstractComponent;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractCompositeComponent;
import de.fzi.maintainabilitymodel.architecturemodel.util.ArchitecturemodelSwitch;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.SelectioncontainerFactoryImpl;

public class ComponentContainerCreationSwitch extends
		ArchitecturemodelSwitch<AbstractContainer> {
	
	private CompositeTaskDerivationContainer workplanContainer;
	
	public ComponentContainerCreationSwitch(
			CompositeTaskDerivationContainer workplanContainer) {
		this.workplanContainer = workplanContainer;
	}

	@Override
	public AbstractContainer caseAbstractCompositeComponent(
			AbstractCompositeComponent object) {
		CompositeComponentSelectionContainer container = SelectioncontainerFactoryImpl.eINSTANCE
        			.createCompositeComponentSelectionContainer();
		container.setAbstractCompositeComponent(object);
		container.setBasicActivity(null);
		
		this.workplanContainer.getCompositeComponentSelectionContainer().add(container);
		this.workplanContainer.getWorkplan().getModelElementToContainerMap().put(object, container);
		
		return container;
	}
	
	@Override
	public AbstractContainer caseAbstractComponent(AbstractComponent object) {
		ComponentSelectionContainer container = SelectioncontainerFactoryImpl.eINSTANCE
		.createComponentSelectionContainer();
		container.setComponenttype(object);
		container.setBasicActivity(null);
		
		this.workplanContainer.getComponentContainers().add(container);
		this.workplanContainer.getWorkplan().getModelElementToContainerMap().put(object, container);
		
		return container;
	}
}
