package de.fzi.kamp.service.architecturemodel.impl;

import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.architecturemodel.AbstractComponent;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterface;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterfacePort;

/**
 * A container class which wraps some information taken from the referenced
 * ServiceArchitectureMetaModel (SAMM) to be able to work with it in the workplan.
 * 
 * @author tknapp
 * 
 */
public class TransportInterfaceInformationContainer {
    private final static Logger logger = Logger.getLogger(TransportInterfaceInformationContainer.class);

    /**
     * An interface (model element taken from SAMM).
     */
    private AbstractInterface iface;

    /**
     * A component (model element taken from SAMM).
     */
    private AbstractComponent component;

    /**
     * A list of interface ports (model elements from SAMM) which implement the interface described
     * before and which belong to the previously described component.
     */
    private List<AbstractInterfacePort> interfacePorts;

    /**
     * The only constructor for this class.
     * 
     * @param iface
     *            Interface which is implemented by the interface ports.
     * @param component
     *            The component the interface ports belong to.
     */
    public TransportInterfaceInformationContainer(AbstractInterface iface, AbstractComponent component) {
        super();
        this.iface = iface;
        this.component = component;
        this.interfacePorts = new LinkedList<AbstractInterfacePort>();

    }

    public AbstractInterface getIface() {
        return iface;
    }

    public AbstractComponent getComponent() {
        return component;
    }

    public List<AbstractInterfacePort> getInterfacePorts() {
        return interfacePorts;
    }
}
