package de.fzi.kamp.service.architecturemodel.impl;

import java.util.HashMap;
import java.util.Iterator;

import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import eu.qimpress.samm.core.NamedEntity;


public class SAMMProxyMap extends HashMap<NamedEntity, AbstractModelElement> {
	
	/**
	 * The methods containsKey() and get() have to be overwritten, because of the 2:1 mapping
	 * of the SAMMOperationImplementationProxy. it is not enough to compare the keys itself,
	 * but the inner interface port and operation have to be compared to find the right proxy. 
	 * @author tknapp
	 */
	private static final long serialVersionUID = 1L;

	@Override
	public boolean containsKey(Object key) {
		if(super.containsKey(key)){
			return true;
		}else{
			if(key instanceof MapKeyForSAMMOperationImplementationProxy){
				Iterator<NamedEntity> it = keySet().iterator();
				while(it.hasNext()){
					NamedEntity entity = it.next();
					if(entity instanceof MapKeyForSAMMOperationImplementationProxy){
						MapKeyForSAMMOperationImplementationProxy opImpProxy =
							(MapKeyForSAMMOperationImplementationProxy)entity;
						MapKeyForSAMMOperationImplementationProxy keyToFind = 
							(MapKeyForSAMMOperationImplementationProxy)key;
						
						if(opImpProxy.getPort() == keyToFind.getPort() &&
								opImpProxy.getOperation() == keyToFind.getOperation()){
							return true;
						}
					}
				}
			}
		}		
		return false;
	}
	
	@Override
	public AbstractModelElement get(Object key) {
		if(key instanceof MapKeyForSAMMOperationImplementationProxy){
			Iterator<NamedEntity> it = keySet().iterator();
			while(it.hasNext()){
				NamedEntity entity = it.next();
				if(entity instanceof MapKeyForSAMMOperationImplementationProxy){
					MapKeyForSAMMOperationImplementationProxy opImpProxy =
						(MapKeyForSAMMOperationImplementationProxy)entity;
					MapKeyForSAMMOperationImplementationProxy keyToFind = 
						(MapKeyForSAMMOperationImplementationProxy)key;
					
					if(opImpProxy.getPort() == keyToFind.getPort() &&
							opImpProxy.getOperation() == keyToFind.getOperation()){
						return super.get(opImpProxy);
					}
				}
			}
		}
		return super.get(key);				
	}
}
