package de.fzi.kamp.service.architecturemodel.impl;

import java.util.Map;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;

/**
 * This class serves as a key for the proxy-map in the SAMMArchitectureModelProvider. This list collects
 * all proxies which have been created once, so that they don't have to be created each time. The class
 * is necessary, because both elements (interface port and operation) are necessary to identify an 
 * SAMMOperationImplementationProxy.
 * The class implements the interface "NamedEntity", because the key has to be of this type.
 * @author tknapp
 *
 */
public class MapKeyForSAMMOperationImplementationProxy implements NamedEntity {
	
	InterfacePort port = null;
	Operation operation = null;
	
	public InterfacePort getPort() {
		return port;
	}

	public void setPort(InterfacePort port) {
		this.port = port;
	}

	public Operation getOperation() {
		return operation;
	}

	public void setOperation(Operation operation) {
		this.operation = operation;
	}
	
	@Override
	public boolean equals(Object obj) {
		if(obj instanceof MapKeyForSAMMOperationImplementationProxy){
			MapKeyForSAMMOperationImplementationProxy elementToCompare = (MapKeyForSAMMOperationImplementationProxy)obj;
			if(elementToCompare.getOperation().equals(operation) &&
				elementToCompare.getPort().equals(port)){
				return true;
			}
		}
		return super.equals(obj);
	}
	
	/*
	 * All methods from here on are not necessary.
	 * (non-Javadoc)
	 * @see eu.qimpress.samm.core.NamedEntity#getName()
	 */
	
	@Override
	public String getName() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setName(String value) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getDocumentation() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void setDocumentation(String value) {
		// TODO Auto-generated method stub

	}

	@Override
	public String getId() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean idHasToBeUnique(DiagnosticChain diagnostics,
			Map<Object, Object> context) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void setId(String value) {
		// TODO Auto-generated method stub

	}

	@Override
	public TreeIterator<EObject> eAllContents() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public EClass eClass() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public EObject eContainer() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public EStructuralFeature eContainingFeature() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public EReference eContainmentFeature() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public EList<EObject> eContents() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public EList<EObject> eCrossReferences() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object eGet(EStructuralFeature feature) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object eGet(EStructuralFeature feature, boolean resolve) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean eIsProxy() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean eIsSet(EStructuralFeature feature) {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public Resource eResource() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void eSet(EStructuralFeature feature, Object newValue) {
		// TODO Auto-generated method stub

	}

	@Override
	public void eUnset(EStructuralFeature feature) {
		// TODO Auto-generated method stub

	}

	@Override
	public EList<Adapter> eAdapters() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean eDeliver() {
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public void eNotify(Notification notification) {
		// TODO Auto-generated method stub

	}

	@Override
	public void eSetDeliver(boolean deliver) {
		// TODO Auto-generated method stub

	}

}
