package de.fzi.kamp.service.architecturemodel.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.model.RepositoryModels;

public class BackboneModelLoader {
    private final static Logger logger = Logger.getLogger(BackboneModelLoader.class);

    private IMainEditor mainEditor;

    public BackboneModelLoader(IMainEditor mainEditor) {

        this.mainEditor = mainEditor;

        // this.logger = Logger.getRootLogger();
        // if (!logger.getAllAppenders().hasMoreElements()) {
        // SimpleLayout layout = new SimpleLayout();
        // ConsoleAppender consoleAppender = new ConsoleAppender( layout );
        // this.logger.addAppender( consoleAppender );
        // }
    }

    public List<IQModel> loadArchitectureModelsFromBackbone() {

        List<IQAlternative> alternatives = retrieveAlternatives();

        List<IQModel> samModels = retrieveSAMModels(alternatives);

        return samModels;
    }

    private List<IQAlternative> retrieveAlternatives() {
        List<IQAlternative> alternatives = new ArrayList<IQAlternative>();

        IQApplicationModel applicationModel = QImpressApplicationModelManager.getManager().getQAppModel();

        retrieveAlternativesFromApplicationModel(alternatives, applicationModel);

        return alternatives;
    }

    private void retrieveAlternativesFromApplicationModel(List<IQAlternative> alternatives,
            IQApplicationModel applicationModel) {
        /**
         * The if-case occurs, if the KAMP-File has been opened by clicking on it. The else-branch
         * occurs, if Eclipse is opened and an KAMP-File is automatically opened, too, or if a new
         * KAMP-File has been created.
         */
        /**
         * Not a perfect idea to take the selection, because it does not work if the file is not
         * opened in the package explorer. Direct link to package has to be added.
         */
        // ISelection selection =
        // PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        // if(selection != null && selection instanceof TreeSelection){
        //			
        // this.logger.info("Page count: "+
        // PlatformUI.getWorkbench().getWorkbenchWindows()[0].getPages().length);
        //			
        // this.logger.info("Page count: "+
        // PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getDefinedActivityIds());
        //			
        // Object firstElement = ((TreeSelection)selection).getFirstElement();
        // IProject correspondingProject = null;
        // if(firstElement instanceof File){
        // correspondingProject = ((File)firstElement).getProject();
        // }else{
        // if(firstElement instanceof IProject){
        // correspondingProject = (IProject)firstElement;
        // }
        // }
        // try {
        // if(correspondingProject != null &&
        // correspondingProject.hasNature(QImpressNature.NATURE_ID)){
        // retrieveAlternativesFromProject(alternatives,
        // applicationModel.getQProject(correspondingProject));
        // }
        // } catch (CoreException e) {
        // e.printStackTrace();
        // }
        // }else{

        // this.logger.info("Symbolic bundle name: "+ResourcesPlugin.getPlugin().getBundle().getSymbolicName());

//        for (IQProject project : applicationModel.getQProjects()) {
//            retrieveAlternativesFromProject(alternatives, project);
//        }

         IProject iproject = this.mainEditor.getParentprojectOfKampFile();
        
         //iproject.
         
         IQProject parentProject = applicationModel.getQProject(iproject);
        	    
         if (parentProject != null)
             retrieveAlternativesFromProject(alternatives, parentProject);
         
    }

    private void retrieveAlternativesFromProject(List<IQAlternative> alternatives, IQProject project) {
        try {
            IQAlternative[] alternativesArray = project.getRepository().listAllAlternatives();
            addAlternativesToList(alternatives, alternativesArray);
        } catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    private void addAlternativesToList(List<IQAlternative> alternatives, IQAlternative[] alternativesArray) {
        for (IQAlternative alternative : alternativesArray)
            alternatives.add(alternative);
    }

    private List<IQModel> retrieveSAMModels(List<IQAlternative> alternatives) {

        List<IQModel> samModels = new ArrayList<IQModel>();

        for (IQAlternative alternative : alternatives) {
            IQModel samModel = null;
            samModel = tryToGetSAMModelFromAlternative(alternative);
            if (samModel != null)
                samModels.add(samModel);
            System.out.println(alternative.getInfo().getId());
        }

        return samModels;
    }

    public static IQModel retrieveRepositoryIQModelForIQModel(IQModel iqmodel) {
        try {
            return iqmodel.getAlternative().getModel(RepositoryModels.REPOSITORY_MODEL_EXT);
        } catch (RepositoryException e) {
            e.printStackTrace();
        }
        
        return null;
    }

    
    private IQModel tryToGetSAMModelFromAlternative(IQAlternative alternative) {

        IQModel samModel = null;

        try {
            // Issue: getModel() also creates a new model if there is no!
            samModel = alternative.getModel(RepositoryModels.SERVICE_ARCHITECTURE_MODEL_EXT);
        } catch (RepositoryException e) {
            e.printStackTrace();
        }
        return samModel;
    }

    public static IQModel findIQModelForAlternativeName(String alternativeName, IMainEditor mainEditor) {
        BackboneModelLoader backboneModelLoader = new BackboneModelLoader(mainEditor);
        List<IQModel> newModelList = backboneModelLoader.loadArchitectureModelsFromBackbone();

        for (IQModel model : newModelList) {
            String modelName = calculateNameIdentifierForIQModel(model);

            if (modelName.equals(alternativeName)) {
                return model;
            }
        }

        return null;
    }

    public static String calculateNameIdentifierForIQModel(IQModel model) {
        return calculateNameIdentifierForIQAlternative(model.getAlternative());
    }

    public static String calculateNameIdentifierForIQAlternative(IQAlternative alternative) {
        String alternativeName = alternative.getInfo().getDescription();
        String projectName = alternative.getRepository().getQProject().getProject().getName();

        String modelName = projectName + "/" + alternativeName;

        return modelName;
    }

    public static ArchitecturalAlternative lookupArchitecturalAlternativeForIQModel(IQModel model, List<ArchitecturalAlternative> architectureAlternatives) {
        return lookupArchitecturalAlternativeForIQAlternative(model.getAlternative(), architectureAlternatives);
    }
    
    public static ArchitecturalAlternative lookupArchitecturalAlternativeForIQAlternative(IQAlternative iqAlternative, List<ArchitecturalAlternative> architectureAlternatives) {
        for (ArchitecturalAlternative architectureAlternative : architectureAlternatives) {
            if (architectureAlternative.getName().equals(calculateNameIdentifierForIQAlternative(iqAlternative))) {
                return architectureAlternative;
            }
        }
        
        return null;
    }

}
