package de.fzi.kamp.service.architecturemodel;

import java.util.List;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.swt.widgets.Shell;

import de.fzi.kamp.derivation.IArchitectureModelResolver;
import de.fzi.kamp.service.architecturemodel.impl.TransportInterfaceInformationContainer;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractComponent;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractCompositeComponent;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractDatatype;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterface;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterfacePort;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractOperationImplementation;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import eu.qimpress.samm.staticstructure.ComponentType;

/**
 * Interface for an <code>ArchitectureModelProvider</code>. For more information about the methods
 * see <code>SAMMArchitectureModelProvider</code>.
 * 
 * @author tknapp
 * 
 */
public interface IArchitectureModelProvider extends IArchitectureModelResolver {

    List<AbstractArchitectureModel> loadArchitectureModels(ResourceSet resourceSet, Shell shell);

    List<AbstractArchitectureModel> getArchitectureModels();

    List<AbstractModelElement> getComponents(AbstractArchitectureModel architectureModel);

    List<TransportInterfaceInformationContainer> getInterfaces(AbstractArchitectureModel architectureModel);

    List<AbstractDatatype> getDatatypes(AbstractArchitectureModel architectureModel);

    List<AbstractInterfacePort> getProvidedInterfacePorts(AbstractComponent componenttype);
    
    List<AbstractInterfacePort> getRequiredInterfacePorts(AbstractComponent componenttype);

    List<AbstractOperationImplementation> getOperationImplementations(AbstractInterfacePort interfacePort);

    List<AbstractDatatype> getDataTypesOfInterface(AbstractInterface referencedInterface);

    List<AbstractArchitectureModel> getAllParentModels(AbstractArchitectureModel selectedModel);

	void assignComponentNestingToContainerStructure(CompositeComponentSelectionContainer compositeComponentSelectionContainer, CompositeTaskDerivationContainer workplanContainer);    
    
}
