package de.fzi.kamp.service.architecturemodel;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.ResourceSet;

import de.fzi.kamp.service.architecturemodel.impl.SAMMArchitectureModelProvider;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.main.MaintainabilityAnalysisModel;

/**
 * Factory to create an <code>ArchitectureModelProvider</code> instance.
 * 
 * @author tknapp
 * 
 */
public class ArchitectureModelProviderFactory {
    private final static Logger logger = Logger.getLogger(ArchitectureModelProviderFactory.class);

    /**
     * Creates an <code>ArchitectureModelProvider</code> instance.
     * 
     * @param resourceSet
     *            The resource set underlying this main editor.
     * @param analysisModel
     *            The <code>MaintainabiltyAnalysisModel</code> which needs an architecture model
     *            provider.
     * @param shell
     *            The shell of the used editor.
     * @return The created <code>ArchitectureModelProvider</code> instance.
     */
    public static IArchitectureModelProvider createArchitectureModelProvider(ResourceSet resourceSet,
            MaintainabilityAnalysisModel analysisModel, IMainEditor mainEditor) {
        IArchitectureModelProvider architectureModelProvider = new SAMMArchitectureModelProvider(resourceSet,
                analysisModel, mainEditor);

        return architectureModelProvider;
    }
}
