package de.fzi.kamp.service.analysisinstance;

import java.util.List;

import org.eclipse.swt.widgets.TableItem;

import de.fzi.kamp.service.general.AnalysisManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;

/**
 * Interface for the analysis instance manager. For more information about the methods, see
 * <code>AnalysisInstanceManager</code>.
 * 
 * @author tknapp
 * 
 */

public interface IAnalysisInstanceManager {

    void addAnalysisInstance(AnalysisManager analysisManager);

    // EffortAnalaysisInstance createAnalysisInstance(ArchitecturalAlternative
    // architectureAlternative, ChangeRequest changeRequest);
    void removeAnalysisInstance(EffortAnalysisInstance analysisInstance, TableItem item);

    List<EffortAnalysisInstance> getAnalysisInstances();

    boolean isEnabledDeriveWorkPlanForAnalysisInstance(EffortAnalysisInstance analysisInstance);

    void deriveWorkplanForAnalysisInstance(EffortAnalysisInstance analysisInstance, IMainEditor editor);

    boolean isEnabledEditWorkPlanForAnalysisInstance(EffortAnalysisInstance analysisInstance);

    void editWorkPlanForAnalysisInstance(EffortAnalysisInstance analysisInstance, IMainEditor editor);

    boolean isEnabledCalculateWorkComplexityForAnalysisInstance(EffortAnalysisInstance analysisInstance);

    void calculateWorkComplexityForAnalysisInstance(EffortAnalysisInstance analysisInstance);

    boolean isEnabledStartEffortEstimationInterview(EffortAnalysisInstance analysisInstance);

    void startEffortEstimationInterview(EffortAnalysisInstance analysisInstance);

    boolean isEnabledEditEffortEstimates(EffortAnalysisInstance analysisInstance);

    void editEffortEstimates(EffortAnalysisInstance analysisInstance, IMainEditor editor);

    boolean isEnabledShowResultSummary(EffortAnalysisInstance analysisInstance);

    void showResultSummary(EffortAnalysisInstance instance);
}
