package de.fzi.kamp.service.analysisinstance;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.workplan.ArchitecturalAlternative;
import de.fzi.maintainabilitymodel.workplan.ChangeRequest;
import eu.qimpress.ide.backbone.core.model.IQAlternative;

/**
 * Provides a tuple to transport a pair of architecture alternative and change request from the
 * <link>ArchitectureAlternativeLoadDialog</link> to the <link>AddAnalysisInstanceCommand</link>.
 * 
 * @author tknapp
 */
public class AlternativeAndChangeRequestTuple {
    private final static Logger logger = Logger.getLogger(AlternativeAndChangeRequestTuple.class);

    public ArchitecturalAlternative sourceArchitectureAlternative = null;
    public ArchitecturalAlternative targetArchitectureAlternative = null;
    public ChangeRequest changeRequest = null;
    private boolean isAutomaticDerivation = false;
    
    public void setAutomaticDerivation(boolean isAutomaticDerivation) {
        this.isAutomaticDerivation = isAutomaticDerivation;
    }
    
    public boolean isAutomaticDerivation() {
        return isAutomaticDerivation;
    }

}
