package de.fzi.kamp.derivation;

import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import eu.qimpress.samm.datatypes.Type;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.MessageType;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.Repository;
import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;
import eu.qimpress.samm.staticstructure.util.StaticstructureSwitch;

public class ParentSwitch extends StaticstructureSwitch<Object> {

    private final static Logger logger = Logger.getLogger(ParentSwitch.class);

    private EObject element;
    private BasicActivity basicActivity;
    private DiffWorkplanBuilder workplanBuilder;

    public ParentSwitch(EObject element, BasicActivity basicActivity, DiffWorkplanBuilder workplanBuilder) {
        this.element = element;
        this.basicActivity = basicActivity;
        this.workplanBuilder = workplanBuilder;
    }

    public Object caseRepository(Repository object) {
        logger.info("Repository change");
        ModifyRepositorySwitch meSwitch = new ModifyRepositorySwitch(this.basicActivity, this.workplanBuilder);
        meSwitch.doSwitch(this.element);

        if (this.element instanceof Type) {
            logger.info("Datatype " + this.basicActivity + ": " + this.element.toString());
            this.workplanBuilder.findAndSelectContainer((Type) this.element, this.basicActivity);
        }

        return null;
    }

    @Override
    public Object casePrimitiveComponent(PrimitiveComponent primitiveComponent) {

        // this.workplanBuilder.findAndSelectContainer(primitiveComponent, this.basicActivity);
        // if (primitiveComponent != this.element) {
        // doSwitch(this.element);
        // }
        logger.info("PrimitiveComponent change");
        /**
         * This switch is helpful, because then the unchecked cast of the element to an interface
         * port object is avoided.
         */
        ModifyPrimitiveComponentSwitch pswitch = new ModifyPrimitiveComponentSwitch(this.basicActivity,
                this.workplanBuilder);
        pswitch.doSwitch(element);

        return primitiveComponent;
    }

    @Override
    public Object caseMessageType(MessageType messageType) {

        // this.workplanBuilder.findAndSelectContainer(messageType, this.basicActivity);
        // if (messageType != this.element) {
        // doSwitch(this.element);
        // }
        logger.info("MessageType change");
        ModifyMessageTypeSwitch pswitch = new ModifyMessageTypeSwitch(this.basicActivity, this.workplanBuilder);
        pswitch.doSwitch(element);

        return messageType;
    }

    @Override
    public Object caseInterface(Interface iface) {

        // this.workplanBuilder.findAndSelectContainer(iface, this.basicActivity);
        //
        // if (iface != this.element) {
        // doSwitch(this.element);
        // }
        logger.info("Interface change");
        this.workplanBuilder.findAndSelectContainer(iface, BasicActivity.CHANGE);

        ModifyInterfaceSwitch pswitch = new ModifyInterfaceSwitch(basicActivity, this.workplanBuilder);
        pswitch.doSwitch(element);

        return iface;
    }

    @Override
    public Object caseServiceArchitectureModel(ServiceArchitectureModel serviceArchitectureModel) {
        // logger.info("SAM change");
        if (this.element != serviceArchitectureModel) {
            doSwitch(this.element);
        }
        return serviceArchitectureModel;

        // ModifyServiceArchitectureModelSwitch pswitch = new
        // ModifyServiceArchitectureModelSwitch(basicActivity);
        // pswitch.doSwitch(element);
        // ModifyAllocationSwitch allswitch = new ModifyAllocationSwitch();
        // allswitch.doSwitch(element);
    }

    @Override
    public Object caseOperation(Operation operation) {
        this.workplanBuilder.findAndSelectContainer(operation, this.basicActivity);

        if (operation != this.element) {
            doSwitch(this.element);
        }
        return operation;
    }

}
