package de.fzi.kamp.derivation;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.MessageType;
import eu.qimpress.samm.staticstructure.PrimitiveComponent;
import eu.qimpress.samm.staticstructure.util.StaticstructureSwitch;

public class ModifyRepositorySwitch extends StaticstructureSwitch<Object> {

    private final static Logger logger = Logger.getLogger(ModifyRepositorySwitch.class);

    private BasicActivity basicActivity;
    private DiffWorkplanBuilder workplanBuilder;

    public ModifyRepositorySwitch(BasicActivity basicActivity, DiffWorkplanBuilder workplanBuilder) {
        super();
        this.basicActivity = basicActivity;
        this.workplanBuilder = workplanBuilder;
    }

    public Object caseInterface(Interface object) {
        logger.info("Interface " + this.basicActivity + ": " + object.toString());

        this.workplanBuilder.findAndSelectContainer(object, this.basicActivity);

        return object;
    }

    public Object casePrimitiveComponent(PrimitiveComponent object) {
        logger.info("PrimitiveComponent added: " + object.getName());

        this.workplanBuilder.findAndSelectContainer(object, this.basicActivity);

        return object;
    }

    public Object caseMessageType(MessageType object) {
        logger.info("MessageType added: " + object.getName());

        this.workplanBuilder.findAndSelectContainer(object, this.basicActivity);

        return object;
    }
}
