package de.fzi.kamp.derivation;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.util.StaticstructureSwitch;

public class ModifyPrimitiveComponentSwitch extends StaticstructureSwitch<Object> {

    private final static Logger logger = Logger.getLogger(ModifyPrimitiveComponentSwitch.class);

    private BasicActivity basicActivity;
    private DiffWorkplanBuilder workplanBuilder;

    public ModifyPrimitiveComponentSwitch(BasicActivity basicActivity, DiffWorkplanBuilder workplanBuilder) {
        this.basicActivity = basicActivity;
        this.workplanBuilder = workplanBuilder;
    }

    public Object caseInterfacePort(InterfacePort interfacePort) {

        this.workplanBuilder.findAndSelectContainer(interfacePort, this.basicActivity);

        return (Object) interfacePort;
    }

}
