package de.fzi.kamp.derivation;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import eu.qimpress.samm.staticstructure.Parameter;
import eu.qimpress.samm.staticstructure.util.StaticstructureSwitch;

public class ModifyMessageTypeSwitch extends StaticstructureSwitch<Object> {
    private final static Logger logger = Logger.getLogger(ModifyMessageTypeSwitch.class);

    private BasicActivity basicActivity;
    private DiffWorkplanBuilder workplanBuilder;

    public ModifyMessageTypeSwitch(BasicActivity basicActivity, DiffWorkplanBuilder workplanBuilder) {
        this.basicActivity = basicActivity;
        this.workplanBuilder = workplanBuilder;
    }

    public Object caseParameter(Parameter parameter) {
        logger.info("Parameter added: " + parameter.toString());

        this.workplanBuilder.findAndSelectContainer(parameter, this.basicActivity);

        return parameter;
    }
}
