package de.fzi.kamp.derivation;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import eu.qimpress.samm.staticstructure.Operation;
import eu.qimpress.samm.staticstructure.util.StaticstructureSwitch;

public class ModifyInterfaceSwitch extends StaticstructureSwitch<Object> {

    private final static Logger logger = Logger.getLogger(ModifyInterfaceSwitch.class);

    private BasicActivity basicActivity;

    private DiffWorkplanBuilder workplanBuilder;

    public ModifyInterfaceSwitch(BasicActivity basicActivity, DiffWorkplanBuilder workplanBuilder) {
        super();
        this.basicActivity = basicActivity;
        this.workplanBuilder = workplanBuilder;
    }

    public Object caseOperation(Operation operation) {
        logger.info("Operation " + this.basicActivity + ": " + operation.toString());

        this.workplanBuilder.findAndSelectContainer(operation, this.basicActivity);

        return operation;
    }
}
