package de.fzi.kamp.derivation;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.TaskRationale;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import eu.qimpress.samm.core.NamedEntity;

public class DiffWorkplanBuilder {

    private final static Logger logger = Logger.getLogger(DiffWorkplanBuilder.class);

    private DiffModel diff;
    private Workplan workplan;
    private IArchitectureModelResolver architectureModelResolver;
    private EffortAnalysisInstance analysisInstance;
    private CompositeTask rootTaskInWorkplan;
    private CompositeTaskDerivationContainer compositeTaskDerivationContainer;
    private IWorkplanBuilderResolver builderResolver;
    private DiffModelVisitor diffModelVisitor;

    private CorrespondingContainerFinderForSAMM containerFinder;

    public DiffWorkplanBuilder(DiffModel diff, EffortAnalysisInstance analysisInstance,
            IArchitectureModelResolver architectureModelResolver, IContainerFactory containerFactory,
            IWorkplanBuilderResolver builderResolver) {
        this.diff = diff;
        this.architectureModelResolver = architectureModelResolver;
        this.analysisInstance = analysisInstance;
        this.builderResolver = builderResolver;

        if (analysisInstance.getWorkplan() == null) {
            analysisInstance.setWorkplan(WorkplanFactory.eINSTANCE.createWorkplan());
        }

        this.workplan = analysisInstance.getWorkplan();
        addRootCompositeToWorkplan();
        createWorkplanDerivationContainer(architectureModelResolver, containerFactory);
        this.containerFinder = new CorrespondingContainerFinderForSAMM(this.getCompositeTaskDerivationContainer());

        this.diffModelVisitor = new DiffModelVisitor(this);
    }

    private void addRootCompositeToWorkplan() {
        this.rootTaskInWorkplan = WorkplanFactory.eINSTANCE.createCompositeTask();

        rootTaskInWorkplan.setName("Composite Task");

        TaskRationale rationale = WorkplanFactory.eINSTANCE.createTaskRationale();
        rationale.setDescription("");
        rationale.setKeyword("Automatically derived composite task");
        rootTaskInWorkplan.setTaskrationale(rationale);

        this.workplan.getTasks().add(this.rootTaskInWorkplan);
    }

    private void createWorkplanDerivationContainer(IArchitectureModelResolver architectureModelProvider,
            IContainerFactory containerFactory) {
        this.compositeTaskDerivationContainer = containerFactory.createContainer(architectureModelProvider,
                this.analysisInstance, this.rootTaskInWorkplan);
        // FIXME: why do we need a root compositetask derivation container???
        this.workplan.getCompositetaskderivationcontainer().add(this.compositeTaskDerivationContainer);
        this.workplan.getCompositetaskderivationcontainer().get(0).getTopLevelActivityContainer().add(this.compositeTaskDerivationContainer);
    }

    public void buildWorkplanFromDiffResult() {
        for (TreeIterator<EObject> iterator = diff.eAllContents(); iterator.hasNext();) {
            EObject el = iterator.next();
            diffModelVisitor.doSwitch(el);
        }
        this.builderResolver.fillTasklistOfWorkplan(this.compositeTaskDerivationContainer, this.workplan);
        this.builderResolver.showWorkplanChanges(this.analysisInstance);

    }

    public void findAndSelectContainer(NamedEntity modelElement, BasicActivity basicActivity) {
        AbstractModelElement proxy = this.architectureModelResolver.getSAMMProxyElement(modelElement);
        if (proxy != null) {
            AbstractContainer container = containerFinder.doSwitch(proxy);
            if (container != null) {
                logger.info("Container selected: "+container.toString());
                container.setSelected(true);
                container.setBasicActivity(basicActivity);
            } else {
                logger.warn("AbstractContainer for Modelelement: " + modelElement.getName() + " of Type "
                        + modelElement.getClass().toString() + " not found.");
            }
        }
    }

    public IArchitectureModelResolver getArchitectureModelResolver() {
        return architectureModelResolver;
    }

    public Workplan getWorkplan() {
        return this.workplan;
    }

    public CompositeTaskDerivationContainer getCompositeTaskDerivationContainer() {
        return this.compositeTaskDerivationContainer;
    }
}
