package de.fzi.kamp.derivation;

import org.apache.log4j.Logger;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.diff.metamodel.util.DiffSwitch;
import org.eclipse.emf.ecore.EObject;

import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;

public class DiffModelVisitor extends DiffSwitch<EObject> {

    private final static Logger logger = Logger.getLogger(DiffModelVisitor.class);

    private DiffWorkplanBuilder workplanBuilder;

    public DiffModelVisitor(DiffWorkplanBuilder workplanBuilder) {
        this.workplanBuilder = workplanBuilder;
    }

    /**
     * From here on the probable cases are listed. With them all change types should be
     * recognizable.
     */
    public EObject caseModelElementChangeLeftTarget(ModelElementChangeLeftTarget object) {
        EObject parent = object.getRightParent();
        EObject element = object.getLeftElement();

        logger.info("Case LEFT TARGET");

        handleElement(BasicActivity.ADD, parent, element);
        return object;
    }

    public EObject caseModelElementChangeRightTarget(ModelElementChangeRightTarget object) {
        EObject parent = object.getLeftParent();
        EObject element = object.getRightElement();

        logger.info("Case RIGHT TARGET");
        handleElement(BasicActivity.REMOVE, parent, element);
        return object;
    }

    @Override
    public EObject caseAttributeChange(AttributeChange object) {
        logger.info("Case ATTRIBUTE CHANGE");
        return object;
    }

    @Override
    public EObject caseReferenceChange(ReferenceChange object) {
        logger.info("Case REFERENCE CHANGE");
        return object;
    }

    public EObject caseUpdateReference(UpdateReference object) {

        // interface type change of interfaceport
        if (object.getReference().getName().equals("interfaceType")) {
            EObject leftElement = object.getLeftElement();

            if (leftElement instanceof InterfacePort) {
                Interface newInterfaceType = ((InterfacePort) leftElement).getInterfaceType();

                logger.info("Changed interface type of " + leftElement.toString() + " to "
                        + newInterfaceType.toString());
            }
        }
        return object;
    }

    @Override
    public EObject caseDiffGroup(DiffGroup object) {
        for (DiffElement element : object.getSubDiffElements()) {
            doSwitch(element);
        }
        return object;
    }

    @Override
    public EObject defaultCase(EObject object) {
        logger.info("DEFAULT CASE REACHED!!! Class: " + object.getClass());
        return object;
    }

    private void handleElement(BasicActivity basicActivity, EObject parent, EObject element) {
        ParentSwitch parentSwitch = new ParentSwitch(element, basicActivity, this.workplanBuilder);
        parentSwitch.doSwitch(parent);
    }
}
