package de.fzi.kamp.derivation;

import org.apache.log4j.Logger;

import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterface;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMCompositeComponentProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMDatatypeProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfacePortProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMInterfaceProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMOperationDefinitionProxy;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMOperationImplementationProxy;
import de.fzi.maintainabilitymodel.architecturemodel.util.ArchitecturemodelSwitch;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationImplementationSelectionContainer;

/**
 * This switch looks for an corresponding container for a given SAMM element. If the container
 * does not exist, <code>null</code> is returned.  
 * @author tknapp
 *
 */
public class CorrespondingContainerFinderForSAMM extends ArchitecturemodelSwitch<AbstractContainer> {

    private final static Logger logger = Logger.getLogger(CorrespondingContainerFinderForSAMM.class);

    private CompositeTaskDerivationContainer rootContainer;

    public CorrespondingContainerFinderForSAMM(CompositeTaskDerivationContainer rootContainer) {
        this.rootContainer = rootContainer;
    }

    @Override
    public AbstractContainer caseSAMMCompositeComponentProxy(
    		SAMMCompositeComponentProxy object) {
    	for (CompositeComponentSelectionContainer compositeComponentContainer : this.rootContainer.getCompositeComponentSelectionContainer()) {
    		if(((SAMMCompositeComponentProxy)compositeComponentContainer).getCompositeComponent().equals(object)){            		
            		return compositeComponentContainer;
            }                		
        }
    	return null;
    }
    
    @Override
    public AbstractContainer caseSAMMComponentProxy(SAMMComponentProxy object) {
        for (ComponentSelectionContainer componentContainer : this.rootContainer.getComponentContainers()) {
            if (componentContainer.getComponenttype().equals(object.getComponenttype())) {
            	return componentContainer;
            }
        }
        return null;
    }

    @Override
    public AbstractContainer caseSAMMInterfaceProxy(SAMMInterfaceProxy object) {
        for (InterfaceSelectionContainer interfaceSelectionContainer : this.rootContainer
                .getInterfaceSelectionContainers()) {
            if (interfaceSelectionContainer.getReferencedInterface().equals(object)) {
                return interfaceSelectionContainer;
            }
        }
        return null;
    }

    @Override
    public AbstractContainer caseSAMMInterfacePortProxy(SAMMInterfacePortProxy object) {
        for (InterfacePortSelectionContainer interfacePortSelectionContainer : this.rootContainer
                .getInterfacePortSelectionContainer()) {
            if (interfacePortSelectionContainer.getInterfaceport().equals(object)) {
                return interfacePortSelectionContainer;
            }
        }
        return null;
    }
    
    @Override
    public AbstractContainer caseSAMMOperationImplementationProxy(
    		SAMMOperationImplementationProxy object) {
    	 for (OperationImplementationSelectionContainer operationSelectionContainer : this.rootContainer
                 .getOperationImplementationSelectionContainer()) {
             if (operationSelectionContainer.getOperation().equals(object.getOperation()) &&
            		 operationSelectionContainer.getParent().equals(object.getInterfacePort())) {
                 return operationSelectionContainer;
             }
         }
         return null;
    }
    
    @Override
    public AbstractContainer caseSAMMOperationDefinitionProxy(
    		SAMMOperationDefinitionProxy object) {
    	
    	return null;
    }
 
    @Override
    public AbstractContainer caseSAMMDatatypeProxy(SAMMDatatypeProxy object) {
        for (DataTypeSelectionContainer dataTypeSelectionContainer : this.rootContainer
                .getDataTypeSelectionContainers()) {
            if (dataTypeSelectionContainer.getType().equals(object)) {
                return dataTypeSelectionContainer;
            }
        }
        return null;
    }

    @Override
    public AbstractContainer caseAbstractInterface(AbstractInterface object) {
        for (InterfaceSelectionContainer interfaceSelectionContainer : this.rootContainer
                .getInterfaceSelectionContainers()) {
            if (interfaceSelectionContainer.getReferencedInterface().equals(object)) {
                return interfaceSelectionContainer;
            }
        }
        return null;
    }
}
