package de.fzi.kamp.data;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.Operation;


public class WorkplanDerivationContainerALT {
	
	private List<DataTypeSelectionContainerALT> datatypeList;
	private List<InterfaceSelectionContainerALT> interfaceList;
	private List<ComponentSelectionContainerALT> componenList;
	private List<InterfacePortSelectionContainerALT> InterfacePortList;
	private List<OperationSelectionContainerALT> operationsList;
	
	private List<DataTypeSelectionContainerALT> lastShowedDatatypes;
	private List<InterfaceSelectionContainerALT> lastShowedInterfaces;
	private List<ComponentSelectionContainerALT> lastShowedComponents;
	private List<InterfacePortSelectionContainerALT> lastShowedInterfacePorts;
	private List<OperationSelectionContainerALT> lastShowedOperations;
	
	private List<AbstractContainerALT> topActivityList;

	public WorkplanDerivationContainerALT() {
		this.datatypeList = new LinkedList<DataTypeSelectionContainerALT>();
		this.interfaceList = new LinkedList<InterfaceSelectionContainerALT>();
		this.componenList = new LinkedList<ComponentSelectionContainerALT>();
		this.InterfacePortList = new LinkedList<InterfacePortSelectionContainerALT>();	
		this.operationsList = new LinkedList<OperationSelectionContainerALT>();
		this.topActivityList = new ArrayList<AbstractContainerALT>();
		
		
	}
	
	public List<AbstractContainerALT> getTopActivityList() {
		return topActivityList;
	}



	public List<DataTypeSelectionContainerALT> getDatatypeList() {
		return datatypeList;
	}



	public List<InterfaceSelectionContainerALT> getInterfaceList() {
		return interfaceList;
	}



	public List<ComponentSelectionContainerALT> getComponenList() {
		return componenList;
	}



	public List<InterfacePortSelectionContainerALT> getInterfacePortList() {
		return InterfacePortList;
	}

	public List<OperationSelectionContainerALT> getOperationsList() {
		return operationsList;
	}

	
	public List<DataTypeSelectionContainerALT> getLastShowedDatatypes() {
		return lastShowedDatatypes;
	}



	public List<InterfaceSelectionContainerALT> getLastShowedInterfaces() {
		return lastShowedInterfaces;
	}



	public List<ComponentSelectionContainerALT> getLastShowedComponents() {
		return lastShowedComponents;
	}



	public List<InterfacePortSelectionContainerALT> getLastShowedInterfacePorts() {
		return lastShowedInterfacePorts;
	}



	public List<OperationSelectionContainerALT> getLastShowedOperations() {
		return lastShowedOperations;
	}
	
	
}
