package de.fzi.kamp.data;

import java.util.LinkedList;
import java.util.List;

import de.fzi.kamp.data.ComponentSelectionContainerALT.BasicActivity;
import eu.qimpress.samm.datatypes.Type;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.Interface;
import eu.qimpress.samm.staticstructure.InterfacePort;


public class InterfaceSelectionContainerALT extends AbstractContainerALT{

	private Interface iface;
	
	private List<InterfacePort> interfacePortsList;
	
	private boolean alreadyAddedAsTask;
	
	private List<Type> datatypesOfInterface;
	private List<InterfacePortSelectionContainerALT> followUpList;
	
	public InterfaceSelectionContainerALT(Interface iface) {
		super();
		this.iface = iface;
		this.followUpList = new LinkedList<InterfacePortSelectionContainerALT>();
	}

	public Interface getIface() {
		return iface;
	}

	public List<InterfacePort> getInterfacePorts() {
		return interfacePortsList;
	}


	public void setInterfacePorts(List<InterfacePort> interfacePort) {
		this.interfacePortsList = interfacePort;
	}


	public boolean isAlreadyAddedAskTask() {
		return alreadyAddedAsTask;
	}


	public void setAlreadyAddedAskTask(boolean alreadyAddedAsTask) {
		this.alreadyAddedAsTask = alreadyAddedAsTask;
	}


	public List<Type> getDatatypesOfInterface() {
		return datatypesOfInterface;
	}


	public void setDatatypesOfInterface(List<Type> datatypesOfInterface) {
		this.datatypesOfInterface = datatypesOfInterface;
	}

	public List<InterfacePort> getInterfacePortsList() {
		return interfacePortsList;
	}


	public List<InterfacePortSelectionContainerALT> getFollowUpList() {
		return followUpList;
	}
}
