package org.cocome.tradingsystem.testdriver;

import javax.jms.JMSException;
import javax.jms.TopicSubscriber;

import org.cocome.tradingsystem.cashdeskline.events.CashAmountEnteredEvent;
import org.cocome.tradingsystem.cashdeskline.events.ChangeAmountCalculatedEvent;
import org.cocome.tradingsystem.cashdeskline.events.CreditCardScanFailedEvent;
import org.cocome.tradingsystem.cashdeskline.events.ExpressModeDisabledEvent;
import org.cocome.tradingsystem.cashdeskline.events.ExpressModeEnabledEvent;
import org.cocome.tradingsystem.cashdeskline.events.InvalidCreditCardEvent;
import org.cocome.tradingsystem.cashdeskline.events.ProductBarcodeNotValidEvent;
import org.cocome.tradingsystem.cashdeskline.events.RunningTotalChangedEvent;
import org.cocome.tradingsystem.cashdeskline.events.SaleStartedEvent;
import org.cocome.tradingsystem.cashdeskline.events.SaleSuccessEvent;
import org.cocome.tradingsystem.systests.interfaces.IUserDisplay;

/**
 * Glue code for the user display.
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 63 $
 * @levd.rating GREEN Rev: 63
 */
public class UserDisplay extends UpdateReceiver implements IUserDisplay {

	/** Constructor. */
	public UserDisplay(TopicSubscriber subscriber) throws JMSException {
		super(subscriber, RunningTotalChangedEvent.class,
				CashAmountEnteredEvent.class,
				ChangeAmountCalculatedEvent.class,
				ExpressModeDisabledEvent.class, ExpressModeEnabledEvent.class,
				InvalidCreditCardEvent.class, CreditCardScanFailedEvent.class,
				ProductBarcodeNotValidEvent.class, SaleSuccessEvent.class,
				SaleStartedEvent.class);
	}

	/** {@inheritDoc} */
	public boolean isMessageForExpressModeShown() {
		expectMessage(ExpressModeEnabledEvent.class);
		return getLastRelevantMessage() instanceof ExpressModeEnabledEvent;
	}

	/** {@inheritDoc} */
	public boolean isMessageForInvalidBarcodeShown() {
		expectMessage(ProductBarcodeNotValidEvent.class);
		return getLastRelevantMessage() instanceof ProductBarcodeNotValidEvent;
	}

	/** {@inheritDoc} */
	public boolean isPriceShown(int expectedPrice) {
		expectMessage(RunningTotalChangedEvent.class);
		if (getLastRelevantMessage() instanceof RunningTotalChangedEvent) {
			int price = (int) Math
					.round(((RunningTotalChangedEvent) getLastRelevantMessage())
							.getProductPrice() * 100);
			return price == expectedPrice;
		}
		return false;
	}

	/** {@inheritDoc} */
	public boolean isProductNameShown(String expectedName) {
		expectMessage(RunningTotalChangedEvent.class);
		if (getLastRelevantMessage() instanceof RunningTotalChangedEvent) {
			String name = ((RunningTotalChangedEvent) getLastRelevantMessage())
					.getProductName();
			return expectedName.equals(name);
		}
		return false;
	}

	/** {@inheritDoc} */
	public boolean isMessageForCreditCardNotPossibleShown() {
		// FIXME: this is currently not supported by the implementation
		return false;
	}

	/** {@inheritDoc} */
	public boolean isMessageForCreditCardPaymentSuccessfulShown() {
		expectMessage(SaleSuccessEvent.class);
		return getLastRelevantMessage() instanceof SaleSuccessEvent;
	}

	/** {@inheritDoc} */
	public boolean isMessageForCreditCardValidationFailedShown() {
		expectMessage(InvalidCreditCardEvent.class);
		return getLastRelevantMessage() instanceof InvalidCreditCardEvent;
	}
}
