package org.cocome.tradingsystem.testdriver;

import java.util.Date;

import javax.naming.OperationNotSupportedException;

import org.cocome.tradingsystem.inventory.data.store.ProductOrder;
import org.cocome.tradingsystem.inventory.data.store.StockItem;
import org.cocome.tradingsystem.inventory.data.store.Store;
import org.cocome.tradingsystem.systests.interfaces.IOrder;
import org.cocome.tradingsystem.systests.interfaces.IProduct;
import org.cocome.tradingsystem.systests.interfaces.IStorePC;

/**
 * Glue code for the store PC.
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 63 $
 * @levd.rating YELLOW Rev: 56
 */
public class StorePC implements IStorePC {

	/** The index of this stock PC. */
	private final int index;

	/** DB representation of this store. */
	private final Store dbStore;

	/** Create a new stock PC. */
	public StorePC(int index, Enterprise enterprise) {
		this.index = index;
		dbStore = new Store();
		dbStore.setEnterprise(enterprise.getDBEnterprise());
		dbStore.setLocation("Location " + index);
		dbStore.setName("Store" + index);
		DBManager.getInstance().persistDBObject(dbStore);
	}

	/** {@inheritDoc} */
	public int getAmount(IProduct product) {
		ProductWrapper wrapper = (ProductWrapper) product;
		StockItem item = DBManager.getInstance().getStoreQuery()
				.queryStockItem(dbStore.getId(),
						wrapper.getProduct().getBarcode(),
						DBManager.getInstance().createPersistenceContext());
		return (int) item.getAmount();
	}

	/** Returns the incoming amount for a product. */
	/*package*/ int getIncomingAmount(IProduct product) {
		ProductWrapper wrapper = (ProductWrapper) product;
		StockItem item = DBManager.getInstance().getStoreQuery()
				.queryStockItem(dbStore.getId(),
						wrapper.getProduct().getBarcode(),
						DBManager.getInstance().createPersistenceContext());
		return (int) item.getIncomingAmount();
	}
	
	/** {@inheritDoc} */
	public void insertStockItem(IProduct product, int salesPrice, int amount,
			int minAmount) {
		ProductWrapper wrapper = (ProductWrapper) product;

		StockItem item = new StockItem();
		item.setAmount(amount);
		item.setMinStock(minAmount);
		item.setMaxStock(100 * amount);
		item.setProduct(wrapper.getProduct());
		item.setStore(dbStore);
		item.setSalesPrice(salesPrice / 100.);

		DBManager.getInstance().persistDBObject(item);
	}

	/** Returns the index of this stock PC. */
	public int getIndex() {
		return index;
	}

	/** {@inheritDoc} */
	public IOrder createOrder() {
		ProductOrder po = new ProductOrder();
		po.setOrderingDate(new Date());
		po.setStore(dbStore);
		DBManager.getInstance().persistDBObject(po);
		return new OrderWrapper(po);
	}

	/** {@inheritDoc} */
	public void executeOrder(IOrder order)
			throws OperationNotSupportedException {
		// FIXME: this is currently not supported as the relevant methods of the
		// implementation are hard to access
		throw new OperationNotSupportedException();
	}

	/** {@inheritDoc} */
	public void rollInOrder(IOrder order) throws OperationNotSupportedException {
		// FIXME: this is currently not supported as the relevant methods of the
		// implementation are hard to access
		throw new OperationNotSupportedException();
	}
}
