package org.cocome.tradingsystem.testdriver;

import javax.jms.JMSException;
import javax.jms.TopicSubscriber;

import org.cocome.tradingsystem.cashdeskline.events.CashAmountEnteredEvent;
import org.cocome.tradingsystem.cashdeskline.events.CashBoxClosedEvent;
import org.cocome.tradingsystem.cashdeskline.events.ChangeAmountCalculatedEvent;
import org.cocome.tradingsystem.cashdeskline.events.RunningTotalChangedEvent;
import org.cocome.tradingsystem.cashdeskline.events.SaleFinishedEvent;
import org.cocome.tradingsystem.cashdeskline.events.SaleStartedEvent;
import org.cocome.tradingsystem.cashdeskline.events.SaleSuccessEvent;
import org.cocome.tradingsystem.systests.interfaces.IPrinter;

/**
 * Glue code for the printer.
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 63 $
 * @levd.rating GREEN Rev: 63
 */
public class Printer extends UpdateReceiver implements IPrinter {

	/** Constructor. */
	public Printer(TopicSubscriber subscriber) throws JMSException {
		super(subscriber, RunningTotalChangedEvent.class,
				CashAmountEnteredEvent.class,
				ChangeAmountCalculatedEvent.class, SaleStartedEvent.class,
				SaleFinishedEvent.class, CashBoxClosedEvent.class,
				SaleSuccessEvent.class);
	}

	/** {@inheritDoc} */
	public String getLastPrintout() {
		// for this test driver we are not interested in the actual print out
		return "Printout";
	}
}
