package org.cocome.tradingsystem.testdriver;

import org.cocome.tradingsystem.inventory.data.store.OrderEntry;
import org.cocome.tradingsystem.inventory.data.store.ProductOrder;
import org.cocome.tradingsystem.systests.interfaces.IOrder;
import org.cocome.tradingsystem.systests.interfaces.IProduct;

/**
 * Wrapper class for orders.
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 63 $
 * @levd.rating GREEN Rev: 63
 */
public class OrderWrapper implements IOrder {

	/** The wrapped order. */
	private final ProductOrder po;

	/** Create a new wrapped product. */
	public OrderWrapper(ProductOrder po) {
		this.po = po;
	}

	/** {@inheritDoc} */
	public void addOrderItem(IProduct product, int amount) {
		OrderEntry oe = new OrderEntry();
		oe.setAmount(amount);
		oe.setOrder(po);
		oe.setProduct(((ProductWrapper) product).getProduct());
		DBManager.getInstance().persistDBObject(oe);
	}

}
