package org.cocome.tradingsystem.testdriver;

import javax.jms.JMSException;
import javax.jms.TopicSubscriber;

import org.cocome.tradingsystem.cashdeskline.events.ExpressModeDisabledEvent;
import org.cocome.tradingsystem.cashdeskline.events.ExpressModeEnabledEvent;
import org.cocome.tradingsystem.systests.interfaces.ILightsDisplay;

/**
 * Glue code for the lights display.
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 63 $
 * @levd.rating GREEN Rev: 63
 */
public class LightsDisplay extends UpdateReceiver implements ILightsDisplay {

	/** Constructor. */
	public LightsDisplay(TopicSubscriber subscriber) throws JMSException {
		super(subscriber, ExpressModeEnabledEvent.class,
				ExpressModeDisabledEvent.class);
	}

	/** {@inheritDoc} */
	public boolean isExpressModeLightOn() {
		return getLastRelevantMessage() instanceof ExpressModeEnabledEvent;
	}

	/** {@inheritDoc} */
	public boolean isNoCreditCardLightOn() {
		return getLastRelevantMessage() instanceof ExpressModeEnabledEvent;
	}

}
