package org.cocome.tradingsystem.testdriver;

import org.cocome.tradingsystem.inventory.data.enterprise.Product;
import org.cocome.tradingsystem.inventory.data.enterprise.ProductSupplier;
import org.cocome.tradingsystem.inventory.data.enterprise.TradingEnterprise;
import org.cocome.tradingsystem.systests.interfaces.IEnterprise;
import org.cocome.tradingsystem.systests.interfaces.IProduct;
import org.cocome.tradingsystem.systests.interfaces.IStorePC;

/**
 * Glue code for the entire enterprice (i.e. the database).
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 63 $
 * @levd.rating GREEN Rev: 63
 */
public class Enterprise implements IEnterprise {

	/** The DB representation of the enterprise. */
	private final TradingEnterprise dbEnterprise;

	/** The supplier used for all products. */
	private final ProductSupplier defaultSupplier;

	/** Create the enterprise. */
	public Enterprise() {
		dbEnterprise = new TradingEnterprise();
		dbEnterprise.setName("My Enterprise");
		DBManager.getInstance().persistDBObject(dbEnterprise);

		defaultSupplier = new ProductSupplier();
		defaultSupplier.setName("default supplier");
		DBManager.getInstance().persistDBObject(defaultSupplier);
	}

	/** {@inheritDoc} */
	public IProduct createProduct(int barcode, int purchasePrice, String name) {
		Product product = new Product();
		product.setBarcode(barcode);
		product.setName(name);
		product.setPurchasePrice(purchasePrice / 100.);
		product.setSupplier(defaultSupplier);
		DBManager.getInstance().persistDBObject(product);
		return new ProductWrapper(product);
	}

	/** Returns the enterprise DB object. */
	public TradingEnterprise getDBEnterprise() {
		return dbEnterprise;
	}

	/** {@inheritDoc} */
	public boolean existsProductTransfer(IProduct product, IStorePC storeFrom,
			IStorePC storeTo) {

		/*
		 * Currently we only check, if there are incoming goods and not, if they
		 * are really from the expected store.
		 */

		StorePC to = (StorePC) storeTo;
		return (to.getIncomingAmount(product) > 0);
	}

}
