package org.cocome.tradingsystem.testdriver;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;

import org.cocome.tradingsystem.inventory.data.DataIfFactory;
import org.cocome.tradingsystem.inventory.data.persistence.PersistenceContext;
import org.cocome.tradingsystem.inventory.data.persistence.impl.PersistenceContextImpl;
import org.cocome.tradingsystem.inventory.data.store.StoreQueryIf;

/**
 * Supporting singleton for managing the database.
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 63 $
 * @levd.rating GREEN Rev: 63
 */
public class DBManager {

	/** The entity manager factory used here. */
	private final EntityManagerFactory emf;

	/** The object used for querying stores */
	private final StoreQueryIf storeQuery;

	/** The single instance of this manager. */
	private static DBManager instance = null;

	/** Returns the single instance of this manager. */
	public static DBManager getInstance() {
		if (instance == null) {
			instance = new DBManager();
		}
		return instance;
	}

	/** Hidden constructor. */
	private DBManager() {
		emf = Persistence.createEntityManagerFactory("inventory-manager");
		storeQuery = DataIfFactory.getInstance().getStoreQueryIf();
	}

	/** {@inheritDoc} */
	public void persistDBObject(Object dbObject) {
		EntityManager em = emf.createEntityManager();
		EntityTransaction tx = null;
		try {
			tx = em.getTransaction();
			tx.begin();
			em.persist(dbObject);
			tx.commit();
		} finally {
			em.close();
		}
	}

	/** Return the store query object. */
	public StoreQueryIf getStoreQuery() {
		return storeQuery;
	}

	/** Creates a new persistence context, used e.g. for queries. */
	public PersistenceContext createPersistenceContext() {
		EntityManager em = emf.createEntityManager();
		return new PersistenceContextImpl(em);
	}
}
