package org.cocome.tradingsystem.testdriver;

import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.cocome.tradingsystem.systests.interfaces.IBarcodeScanner;
import org.cocome.tradingsystem.systests.interfaces.ICardReader;
import org.cocome.tradingsystem.systests.interfaces.ICashBox;
import org.cocome.tradingsystem.systests.interfaces.ICashDesk;
import org.cocome.tradingsystem.systests.interfaces.ILightsDisplay;
import org.cocome.tradingsystem.systests.interfaces.IPrinter;
import org.cocome.tradingsystem.systests.interfaces.IUserDisplay;

/**
 * The glue code for one cash desk.
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 63 $
 * @levd.rating GREEN Rev: 63
 */
public class CashDesk implements ICashDesk {

	/** The barcode scanner glue. */
	private final IBarcodeScanner barcodeScanner;

	/** The card reader glue. */
	private final ICardReader cardReader;

	/** The cashbox glue. */
	private final ICashBox cashBox;

	/** The light display glue. */
	private final ILightsDisplay lightsDisplay;

	/** The printer glue. */
	private final IPrinter printer;

	/** The user display glue. */
	private final IUserDisplay userDisplay;

	/** Created a new cash desk. */
	public CashDesk(StorePC storePC, int index) throws NamingException,
			JMSException {

		String topicName = "chan" + storePC.getIndex() + "" + index;

		Context jndiContext = new InitialContext();
		TopicConnectionFactory channelConnectionFactory = (javax.jms.TopicConnectionFactory) jndiContext
				.lookup("ChannelConnectionFactory");
		TopicConnection topicConnection = channelConnectionFactory
				.createTopicConnection();
		TopicSession session = topicConnection.createTopicSession(false,
				Session.AUTO_ACKNOWLEDGE);
		Topic topic = (javax.jms.Topic) jndiContext.lookup(topicName);

		TopicPublisher publisher = session.createPublisher(topic);

		barcodeScanner = new BarcodeScanner(publisher, session);
		cardReader = new CardReader(publisher, session);
		cashBox = new CashBox(publisher, session, session
				.createSubscriber(topic));
		lightsDisplay = new LightsDisplay(session.createSubscriber(topic));
		printer = new Printer(session.createSubscriber(topic));
		userDisplay = new UserDisplay(session.createSubscriber(topic));

		topicConnection.start();
	}

	/** {@inheritDoc} */
	public IBarcodeScanner getBarcodeScanner() {
		return barcodeScanner;
	}

	/** {@inheritDoc} */
	public ICardReader getCardReader() {
		return cardReader;
	}

	/** {@inheritDoc} */
	public ICashBox getCashBox() {
		return cashBox;
	}

	/** {@inheritDoc} */
	public ILightsDisplay getLightsDisplay() {
		return lightsDisplay;
	}

	/** {@inheritDoc} */
	public IPrinter getPrinter() {
		return printer;
	}

	/** {@inheritDoc} */
	public IUserDisplay getUserDisplay() {
		return userDisplay;
	}
	
	/** {@inheritDoc} */
	public int getNumberOfExpressSalesForExpressModeSwitch() {
		return 1;
	}

}
