package org.cocome.tradingsystem.testdriver;

import javax.jms.JMSException;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

import org.cocome.tradingsystem.cashdeskline.events.CreditCardScannedEvent;
import org.cocome.tradingsystem.cashdeskline.events.PINEnteredEvent;
import org.cocome.tradingsystem.systests.interfaces.ICardReader;

/**
 * Glue code for the card reader.
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 63 $
 * @levd.rating GREEN Rev: 63
 */
public class CardReader implements ICardReader {

	/** Publisher for sending events. */
	private final TopicPublisher publisher;

	/** Session used for creating object messages. */
	private final TopicSession session;

	/** Constructor. */
	public CardReader(TopicPublisher publisher, TopicSession session) {
		this.publisher = publisher;
		this.session = session;
	}

	/** {@inheritDoc} */
	public void enterCard(int cardNumber) throws JMSException {
		publisher
				.publish(session
						.createObjectMessage(new CreditCardScannedEvent(""
								+ cardNumber)));
	}

	/** {@inheritDoc} */
	public void enterPin(int pin) throws JMSException {
		publisher
				.publish(session.createObjectMessage(new PINEnteredEvent(pin)));
	}

}
