package org.cocome.tradingsystem.testdriver;

import javax.jms.JMSException;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;

import org.cocome.tradingsystem.cashdeskline.events.ProductBarcodeScannedEvent;
import org.cocome.tradingsystem.systests.interfaces.IBarcodeScanner;

/**
 * Glue code for the barcode scanner.
 * 
 * @author Benjamin Hummel
 * @author $Author: hummel $
 * @version $Rev: 63 $
 * @levd.rating GREEN Rev: 63
 */
public class BarcodeScanner implements IBarcodeScanner {

	/** Publisher for sending events. */
	private final TopicPublisher publisher;

	/** Session used for creating object messages. */
	private final TopicSession session;

	/** Constructor. */
	public BarcodeScanner(TopicPublisher publisher, TopicSession session) {
		this.publisher = publisher;
		this.session = session;
	}

	/** {@inheritDoc} */
	public void sendBarcode(int barcode) throws JMSException {
		publisher.publish(session
				.createObjectMessage(new ProductBarcodeScannedEvent(barcode)));
	}
}
