package org.cocome.tradingsystem.systests.util;


/**
 * Simple storage class for generated products.
 * 
 * @author Benjamin Hummel
 * @author Christian Pfaller
 * @author $Author: pfaller $
 * @version $Rev: 60 $
 * @levd.rating GREEN Rev: 60
 */
public final class GeneratedStockItem {

	/** The product this item is from. */
	final GeneratedProduct product; 

	/** The sales price in cents. */
	final int salesPrice;

	/** The amount currently on stock. */
	final int amount;

	/** The amount theat should be at least available in the store. */
	final int minAmount;

	/** The amount theat could be at maximum in the store. */
	final int maxAmount;

	/**
	 * Create a new instance. This has package visibility, as it should only be
	 * generated by the StockGenerator.
	 */
	GeneratedStockItem(GeneratedProduct product, int salesPrice,
			int amount, int minAmount, int maxAmount) {
		this.product = product;
		this.salesPrice = salesPrice;
		this.amount = amount;
		this.minAmount = minAmount;
		this.maxAmount = maxAmount;
	}

	/** Returns the amount currently on stock. */
	public int getAmount() {
		return amount;
	}

	/** Returns the amount theat should be at least available in the store. */
	public int getMinAmount() {
		return minAmount;
	}

	/** Returns the product this item is from. */
	public GeneratedProduct getProduct() {
		return product;
	}

	/** Returns the sales price in cents. */
	public int getSalesPrice() {
		return salesPrice;
	}

	/**
	 * Returns the maximum amount of products possible to keep in stock
	 */
	public int getMaxAmount() {
		return maxAmount;
	}

}