package org.cocome.tradingsystem.systests.util;

import org.cocome.tradingsystem.systests.interfaces.IProduct;

/**
 * Simple storage class for generated products.
 * 
 * @author Benjamin Hummel
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Rev: 60 $
 * @levd.rating GREEN Rev: 60
 */
public final class GeneratedProduct {

	/** The barcode of the product. */
	final int barcode;

	/** The purchase price of the product in cents. */
	final int purchasePrice;

	/** The name of the product. */
	final String name;

	/** The product itself. */
	final IProduct product;

	/**
	 * Create a new instance. This has package visibility, as it should only be
	 * generated by the StockGenerator.
	 */
	/* package */GeneratedProduct(int barcode, int purchasePrice, String name,
			IProduct product) {
		this.barcode = barcode;
		this.purchasePrice = purchasePrice;
		this.name = name;
		this.product = product;
	}

	/** Returns the barcode. */
	public int getBarcode() {
		return barcode;
	}

	/** Returns the name. */
	public String getName() {
		return name;
	}

	/** Returns the product. */
	public IProduct getProduct() {
		return product;
	}

	/** Returns the purchase price in cents. */
	public int getPurchasePrice() {
		return purchasePrice;
	}
}