package org.cocome.tradingsystem.systests.scenarios;

import java.util.concurrent.TimeoutException;

import org.cocome.tradingsystem.systests.interfaces.IProduct;
import org.cocome.tradingsystem.systests.interfaces.IStorePC;
import org.cocome.tradingsystem.systests.util.GeneratedStockItem;

/**
 * This test case covers use case 8 - prodcut exchange among stores
 * 
 * @author Christian Pfaller
 */
public class ProductExchangeAmongStoresTest extends ProcessSaleBase {

	private int productIndex;

	@Override
	protected void setUp() throws Exception {
		super.setUp();

		// create two more sores, store no. 0 was already created in
		// super.setUp();
		createStore(0); // store no. 1
		createStore(0); // store no. 2

		productIndex = productGenerator.generate();

		// set stock amount almost low for store no. 0
		stores.get(0).getStockGenerator().generate(productIndex, 100, 100, 200);

		// set enough amount in store no. 1
		stores.get(1).getStockGenerator().generate(productIndex, 10, 300, 300);

		// set nothing to store no. 2 --> they don't have it at all

	}

	/** Execute the test scenario. */
	public void testScenario() throws Exception {

		// execute sales szenario
		initializeCashDesk(0, 0);

		// we  buy one item of the product --> low on stock  (amount < minAmount)
		startNewSale(1);
		enterProduct(); // first piece

		finishSale();
		handleCashPayment();

		// check for products transfer between store
		IProduct product = productGenerator.getGeneratedProduct(productIndex)
				.getProduct();
		IStorePC store0 = stores.get(0).getStorePC();
		IStorePC store1 = stores.get(1).getStorePC();
		IStorePC store2 = stores.get(2).getStorePC();
		
		Thread.sleep(5000);

		// there should be transfer form store 1 to store 0
		assertTrue("There should be transfer form store 1 to store 0",
				enterprise.existsProductTransfer(product, store1, store0));

		// there should be no transfer form store 2 to store 0
		assertFalse("There should be NO transfer form store 2 to store 0",
				enterprise.existsProductTransfer(product, store2, store0));

		// there should be no transfer form store 1 to store 2
		assertFalse("There should be NO transfer form store 1 to store 2",
				enterprise.existsProductTransfer(product, store1, store2));

	}

	/**
	 * Executes actions for entering the specific product
	 */
	private void enterProduct() throws Exception, TimeoutException {

		// The cashier enters item identifier.
		GeneratedStockItem stockItem = stores.get(0).getStockGenerator()
				.getGeneratedStockItem(productIndex);

		int barcode = stockItem.getProduct().getBarcode();
		// This can be done ... by using the barcode scanner.
		cashDesk.getBarcodeScanner().sendBarcode(barcode);

	}

}
