package org.cocome.tradingsystem.systests.scenarios;

import java.util.concurrent.TimeoutException;

import org.cocome.tradingsystem.systests.util.GeneratedStockItem;

/**
 * This test covers use case 1 (ProcessSale) with an invalid item id entered
 * (excepetion in step 3).
 * 
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Rev: 64 $
 * @levd.rating GREEN Rev: 64
 */
public class ProcessSaleInvalidItemIdTest extends ProcessSaleBase {

	/** Executes the test scenario. */
	public void testScenario() throws Exception {

		// a single purchase of on product will be done

		initializeCashDesk(0, 0);
		startNewSale(1);
		
		enterAllRemainingProducts();
		
		finishSale();
		handleCashPayment();
		updateInventory();
	}

	/**
	 * Executes actions for entering a product where at first the barcode reader
	 * send an invalid item id.
	 */
	protected void enterAllRemainingProducts() throws Exception,
			TimeoutException {

		// get an item customer wants to buy
		GeneratedStockItem stockItem = stores.get(0).getStockGenerator()
				.getGeneratedStockItem(2 * currentlySold + 3);
		products[currentlySold] = stockItem.getProduct().getProduct();
		expectedAmounts[currentlySold] = stockItem.getAmount() - 1;
		priceSum += stockItem.getSalesPrice();

		// barcode scanner reads an unkown barcode
		int invalidBarcode = productGenerator.getUnusedBarcode();
		cashDesk.getBarcodeScanner().sendBarcode(invalidBarcode);

		// 1. System signals error
		cashDesk.getUserDisplay().waitForUpdate(500);
		assertTrue("The message indicating invalid Barcode should be shown.",
				cashDesk.getUserDisplay().isMessageForInvalidBarcodeShown());

		// 2.1.1 Cashier again enters item Id (using barcode scanner)
		int correctBarcode = stockItem.getProduct().getBarcode();
		cashDesk.getBarcodeScanner().sendBarcode(correctBarcode);

		// The system records sale item and presents product description,
		// price, and running total.
		cashDesk.getUserDisplay().waitForUpdate(1000);
		assertTrue(cashDesk.getUserDisplay().isPriceShown(
				stockItem.getSalesPrice()));
		assertTrue(cashDesk.getUserDisplay().isProductNameShown(
				stockItem.getProduct().getName()));

		currentlySold++;
	}
}
