package org.cocome.tradingsystem.systests.scenarios;

/**
 * This test covers use case 1 (ProcessSale) for credit card payment without any
 * exceptions.
 * 
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Revision: 1.1 $
 * @lev.rating GREEN Rev: 65
 */

public class ProcessSaleCreditCardTest extends ProcessSaleBase {

	/** Number of valid credit card in this test */
	private final static int CARD_NUMBER = 99999;

	/** PIN of valid credit card in ths test */
	private final static int CARD_PIN = 1234;

	/**
	 * Mony available for the credit card, given in cents Thus 1 Million Euro
	 * should be enough to cover every sale
	 */
	private final static int CARD_MONEY = 100000000;

	/** Executes the test scenario. */
	public void testScenario() throws Exception {
		// first, create a valid credit card
		bank.createCreditCard(CARD_NUMBER, CARD_PIN, CARD_MONEY);

		// execute sales szenario
		initializeCashDesk(0, 0);
		startNewSale();
		enterAllRemainingProducts();
		finishSale();
		handleCreditCardPayment();
		updateInventory();
	}

	/**
	 * Executes actions for credit card payment. Corresponds to step 5 b. in use
	 * case 1.
	 */
	protected void handleCreditCardPayment() throws Exception {
		// 5 b. The cashier presses button for credit card payment.
		cashBox.startCreditCardPayment();

		// 5 b. i. Cashier pulls credit card through the card reader
		cashDesk.getCardReader().enterCard(CARD_NUMBER);

		// 5 b. ii. Customer enters PIN
		cashDesk.getCardReader().enterPin(CARD_PIN);

		cashDesk.getUserDisplay().waitForUpdate(500);
		assertTrue(
				"Message for successful credit card payment should be shown",
				cashDesk.getUserDisplay()
						.isMessageForCreditCardPaymentSuccessfulShown());

	}

}
