package org.cocome.tradingsystem.systests.scenarios;

/**
 * This test covers use case 1 (process sale) with exception in step 5.2 (credit
 * card validation fails)
 * 
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Revision: 1.1 $
 * @lev.rating GREEN Rev: 65
 */

public class ProcessSaleCreditCardFailTest extends ProcessSaleBase {

	/** Number of valid credit card in this test */
	private final static int CARD_NUMBER = 99999;

	/** PIN of valid credit card in ths test */
	private final static int CARD_PIN = 1234;

	/**
	 * Mony available for the credit card, given in cents Thus 1 Million Euro
	 * should be enough to cover every sale
	 */
	private final static int CARD_MONEY = 100000000;

	/** Execute the test scenario. */
	public void testScenario() throws Exception {
		// first, create a valid credit card
		bank.createCreditCard(CARD_NUMBER, CARD_PIN, CARD_MONEY);

		// execute sales szenario
		initializeCashDesk(0, 0);
		startNewSale();
		enterAllRemainingProducts();
		finishSale();
		handlePayment();
		updateInventory();
	}

	/**
	 * Executes actions for credit card payment. Corresponds to step 5 b. in use
	 * case 1.
	 */
	protected void handlePayment() throws Exception {
		// 5 b. The cashier presses button for credit card payment.
		cashBox.startCreditCardPayment();

		// 5 b. i. Cashier pulls credit card through the card reader
		cashDesk.getCardReader().enterCard(CARD_NUMBER);

		// try to use credit card with wrong pin
		// provoke card validation failure
		cashDesk.getCardReader().enterPin(0);

		// credit card validation fails
		cashDesk.getUserDisplay().waitForUpdate(500);
		assertTrue("Message for failed credit card validation should be shown",
				cashDesk.getUserDisplay()
						.isMessageForCreditCardValidationFailedShown());

		// do cash payment instead
		handleCashPayment();
	}

}
