package org.cocome.tradingsystem.systests.scenarios;

import java.util.Random;

/**
 * This test covers use case 1 for multiple cash desks in parallel.
 * 
 * @author Benjamin Hummel
 * @author Christian Pfaller
 * @author $Author: hummel $
 * @version $Rev: 64 $
 * @levd.rating GREEN Rev: 64
 */
public class ProcessSaleConcurrentTest extends ProcessSaleBase {

	/** Number of concurrent sales processes. */
	private static final int NUM_PROCESSES = 3;

	/** Execute the test scenario. */
	public void testScenario() throws Exception {

		ProcessSaleBase[] saleProcesses = new ProcessSaleBase[NUM_PROCESSES];
		for (int i = 0; i < NUM_PROCESSES; ++i) {
			saleProcesses[i] = new ProcessSaleBase();
			saleProcesses[i].copySetup(this);
			saleProcesses[i].initializeCashDesk(0, i);
		}

		int numFinished = 0;
		int[] states = new int[NUM_PROCESSES];
		Random interleavingGenerator = new Random(42);

		while (numFinished < NUM_PROCESSES) {
			int pid = interleavingGenerator.nextInt(NUM_PROCESSES);
			switch (states[pid]) {
			case 0:
				saleProcesses[pid].startNewSale(15);
				break;
			case 1:
			case 2:
			case 3:
				saleProcesses[pid].enterProducts(5);
				break;
			case 4:
				saleProcesses[pid].finishSale();
				break;
			case 5:
				saleProcesses[pid].handleCashPayment();
				break;
			case 6:
				++numFinished;
				break;
			}
			++states[pid];
		}
	}

}
